const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_temp_masterfriability', {
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    SrNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Area: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue: "NULL"
    },
    CubicleName: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CubicleType: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    IPQCType: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    CoatingType: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    ProductType: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    ReportType: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
        //comment: "0:Regular 1: Initial"
    },
    Department: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    BFGCode: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    ProductName: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL"
    },
    PVersion: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Version: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    BatchNo: { 
      type: DataTypes.STRING(25),
      allowNull: true,
      defaultValue: "NULL"
    },
    BMRNo: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    BatchSize: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    }, 
    MachineCode: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    BalanceId: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    FriabilityID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Idsno: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Qty: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    UserId: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    PrTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    PrEndDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    PrEndTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    Side: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Stage: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Unit: {
      type: DataTypes.STRING(5),
      allowNull: true,
      defaultValue: "NULL"
    },
    DecimalPoint: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    NMT: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "0"
    },
    SetCount: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    SetRPM: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    IsArchived: {
      type: DataTypes.INTEGER,
      allowNull: true, 
      defaultValue: 0,
    },
    BatchComplete: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    CheckedByID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    CheckedByName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    CheckedByDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    Lot: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    LayerName: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Layer: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },      
    Inprocess: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Remark: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    CheckedByTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    WeighmentMode: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    HMIID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    SFOID: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NA"
    },
    Test_Seq: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Repetition: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    MPN_Code: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue: "NULL"
    },
   
  }, {
    sequelize,
    tableName: 'tbl_temp_masterfriability',
    timestamps: false,
    // indexes: [
    //   {
    //     name: "PRIMARY",
    //     unique: true,
    //     using: "BTREE",
    //     fields: [
    //       { name: "SrNo" },
    //     ]
    //   },
    //   {
    //     name: "index1",
    //     using: "BTREE",
    //     fields: [
    //       { name: "ProductType" },
    //       { name: "PrDate" },
    //       { name: "ReportType" },
    //     ]
    //   },
    // ]
  });
  seq.removeAttribute('id')
  return seq
};
